<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="description" content="Responsive Bootstrap 4 Admin &amp; Dashboard Template">
	<meta name="author" content="Bootlab">

	<title>AppStack - Responsive Admin &amp; Dashboard Template</title>
	<link href="css/app.css" rel="stylesheet">
	<link href="dist/css/app.css" rel="stylesheet">

</head>

<body>
	<div class="wrapper">
		<nav class="sidebar sidebar-sticky">
			<div class="sidebar-content  js-simplebar">
				<a class="sidebar-brand" href="/">
          <i class="align-middle" data-feather="box"></i>
          <span class="align-middle">Statistique</span>
        </a>

				<ul class="sidebar-nav">
					<li class="sidebar-header">
						Menu
					</li>
					<li class="sidebar-item active">
						<a href="#dashboard" data-toggle="collapse" class="sidebar-link" onclick="loadingPage('ajax/mydashboard');">
              <i class="align-middle" data-feather="sliders"></i> <span class="align-middle">Accueil</span>
            </a>
					</li>
					<li class="sidebar-item">
						<a href="#pages" data-toggle="collapse" class="sidebar-link collapsed">
              <i class="align-middle" data-feather="layout"></i> <span class="align-middle">Vues</span>
            </a>
						<ul id="pages" class="sidebar-dropdown list-unstyled collapse ">
							<li class="sidebar-item"><a class="sidebar-link" href="#" onclick="loadingPage('ajax/vue/1');">TRS ligne 1</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="#" onclick="loadingPage('ajax/vue/1');">TRS ligne 2</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="#" onclick="loadingPage('ajax/vue/1');">Répartition des causes d'arrét</a></li>
						</ul>
					</li>
					<li class="sidebar-item">
						<a href="#layouts" data-toggle="collapse" class="sidebar-link collapsed">
              <i class="align-middle" data-feather="monitor"></i> <span class="align-middle">Rapport</span>
            </a>
						<ul id="layouts" class="sidebar-dropdown list-unstyled collapse ">
							<li class="sidebar-item"><a class="sidebar-link" href="#"  onclick="loadingPage('ajax/report/1');">Ligne 1 / 30 jours</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="#">Ligne 2 / 30 jours</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="#">Ligne 1 / 12 mois</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="#">Ligne 2 / 12 mois</a></li>
						</ul>
					</li>
					<li class="sidebar-item">
						<a href="#tables" class="sidebar-link" onclick="loadingPage('ajax/alarmsList');">
              				<i class="align-middle" data-feather="list"></i> <span class="align-middle">Historique des Alarmes</span>
            			</a>
					</li>
					<li class="sidebar-header">
						Paramétrage
					</li>
					<li class="sidebar-item">
						<a href="#ui" data-toggle="collapse" class="sidebar-link collapsed">
              <i class="align-middle" data-feather="grid"></i> <span class="align-middle">Sources</span>
            </a>
						<ul id="ui" class="sidebar-dropdown list-unstyled collapse ">
							<li class="sidebar-item"><a class="sidebar-link" href="#" onclick="loadingPage('settings/factorycast');">Modules FactoryCast</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="#" onclick="loadingPage('settings/zone');">Zone</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="#" onclick="loadingPage('settings/variable');">Variables</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="#"" onclick="loadingPage('settings/alarm');">Alarmes</a></li>
						</ul>
					</li>
					<li class="sidebar-item">
						<a href="#charts" data-toggle="collapse" class="sidebar-link collapsed">
              <i class="align-middle" data-feather="pie-chart"></i> <span class="align-middle">Vues</span>
            </a>
						<ul id="charts" class="sidebar-dropdown list-unstyled collapse ">
							<li class="sidebar-item"><a class="sidebar-link" href="#">Liste des Vues</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="#">Créer une Vue <span class="sidebar-badge badge badge-primary">+</span></a></li>
						</ul>
					</li>
					<li class="sidebar-item">
						<a href="#forms" data-toggle="collapse" class="sidebar-link collapsed">
              <i class="align-middle" data-feather="check-square"></i> <span class="align-middle">Rapport</span>
            </a>
						<ul id="forms" class="sidebar-dropdown list-unstyled collapse ">
							<li class="sidebar-item"><a class="sidebar-link" href="forms-layouts.html">Liste des Rapports</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="forms-basic-elements.html">Créer un Rapport <span class="sidebar-badge badge badge-primary">+</span></a></li>
						</ul>
					</li>
					<li class="sidebar-item">
						<a href="#tables" data-toggle="collapse" class="sidebar-link collapsed">
              				<i class="align-middle" data-feather="list"></i> <span class="align-middle">Alerte</span>
            			</a>
						<ul id="tables" class="sidebar-dropdown list-unstyled collapse ">
							<li class="sidebar-item"><a class="sidebar-link" href="#">Liste des Alertes</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="#">Destinataires</a></li>
							<li class="sidebar-item"><a class="sidebar-link" href="#">Paramétres d'envoi</a></li>
						</ul>
					</li>
					
				</ul>

			</div>
		</nav>

		<div class="main">
			<nav class="navbar navbar-expand navbar-light bg-white">
				<a class="sidebar-toggle d-flex mr-2">
          <i class="hamburger align-self-center"></i>
        </a>

				<form class="form-inline d-none d-sm-inline-block">
					<input class="form-control form-control-no-border mr-sm-2" type="text" placeholder="Rechercher une variable..." aria-label="Search">
				</form>

				<div class="navbar-collapse collapse">
					<span class="navbar-text ml-auto d-none d-xl-inline-block">
			           Bienvenue.
			         </span>
					<ul class="navbar-nav ml-auto ml-xl-0">
						<div id="downloadLink">
							<li class="nav-item">
								<a class="nav-icon" href="#" onclick="exportPdf();">
									<div class="position-relative">
										<i class="align-middle" data-feather="download"></i>
									</div>
								</a>
					        </li>
				        </div>
						<li class="nav-item dropdown">
							<a class="nav-icon dropdown-toggle" href="#" id="messagesDropdown" data-toggle="dropdown">
								<div class="position-relative">
									<i class="align-middle" data-feather="message-circle"></i>
									<span class="indicator badge-danger">1</span>
								</div>
							</a>
							<div class="dropdown-menu dropdown-menu-lg dropdown-menu-right py-0" aria-labelledby="messagesDropdown">
								<div class="dropdown-menu-header">
									<div class="position-relative">
										Alarmes en cours
									</div>
								</div>
								<div class="list-group">
									<a href="#" class="list-group-item">
										<div class="row no-gutters align-items-center">
											<div class="col-2">
												<!--<img src="dist/img/avatar-5.jpg" class="avatar img-fluid rounded-circle" alt="Ashley Briggs">-->
												<i class="text-danger" data-feather="alert-circle"></i>
											</div>
											<div class="col-10 pl-2">
												<div class="text-dark">Ligne 1</div>
												<div class="text-muted small mt-1">Défaut Manuel sur Ligne 1 : Manque de personnel.</div>
												<div class="text-muted small mt-1">Il y a 15 minutes.</div>
											</div>
										</div>
									</a>
								</div>
								<div class="dropdown-menu-footer">
									<a href="#" class="text-muted" onclick="loadingPage('ajax/alarmsList');">Afficher toutes les alarmes du jour</a>
								</div>
							</div>
						</li>
						
						<!--<li class="nav-item dropdown">
							<a class="nav-icon dropdown-toggle" href="#" id="alertsDropdown" data-toggle="dropdown">
								<div class="position-relative">
									<i class="align-middle" data-feather="bell-off"></i>
								</div>
							</a>
							<div class="dropdown-menu dropdown-menu-lg dropdown-menu-right py-0" aria-labelledby="alertsDropdown">
								<div class="dropdown-menu-header">
									4 New Notifications
								</div>
								<div class="list-group">
									<a href="#" class="list-group-item">
										<div class="row no-gutters align-items-center">
											<div class="col-2">
												<i class="text-danger" data-feather="alert-circle"></i>
											</div>
											<div class="col-10">
												<div class="text-dark">Update completed</div>
												<div class="text-muted small mt-1">Restart server 12 to complete the update.</div>
												<div class="text-muted small mt-1">2h ago</div>
											</div>
										</div>
									</a>
									<a href="#" class="list-group-item">
										<div class="row no-gutters align-items-center">
											<div class="col-2">
												<i class="text-warning" data-feather="bell"></i>
											</div>
											<div class="col-10">
												<div class="text-dark">Lorem ipsum</div>
												<div class="text-muted small mt-1">Aliquam ex eros, imperdiet vulputate hendrerit et.</div>
												<div class="text-muted small mt-1">6h ago</div>
											</div>
										</div>
									</a>
									<a href="#" class="list-group-item">
										<div class="row no-gutters align-items-center">
											<div class="col-2">
												<i class="text-primary" data-feather="home"></i>
											</div>
											<div class="col-10">
												<div class="text-dark">Login from 192.186.1.1</div>
												<div class="text-muted small mt-1">8h ago</div>
											</div>
										</div>
									</a>
									<a href="#" class="list-group-item">
										<div class="row no-gutters align-items-center">
											<div class="col-2">
												<i class="text-success" data-feather="user-plus"></i>
											</div>
											<div class="col-10">
												<div class="text-dark">New connection</div>
												<div class="text-muted small mt-1">Anna accepted your request.</div>
												<div class="text-muted small mt-1">12h ago</div>
											</div>
										</div>
									</a>
								</div>
								<div class="dropdown-menu-footer">
									<a href="#" class="text-muted">Show all notifications</a>
								</div>
							</div>
						</li>-->
						
						<li class="nav-item dropdown">
							<a class="nav-link dropdown-toggle" href="#" id="userDropdown" data-toggle="dropdown">
                <span class="d-inline-block d-sm-none">
                  <i class="align-middle" data-feather="settings"></i>
                </span>
                <span class="d-none d-sm-inline-block">
                  <img src="dist/img/avatar.jpg" class="avatar img-fluid rounded-circle mr-1" alt="Yann Challet" /> <span class="text-dark">Yann Challet</span>
                </span>
              </a>
							<div class="dropdown-menu dropdown-menu-right" aria-labelledby="userDropdown">
								<a class="dropdown-item" href="pages-profile.html"><i class="align-middle mr-1" data-feather="user"></i> Mon Compte</a>
								<div class="dropdown-divider"></div>
								<a class="dropdown-item" href="pages-settings.html">Paramètres</a>
								<a class="dropdown-item" href="#">Aide</a>
								<a class="dropdown-item" href="#">Se déconnecter</a>
							</div>
						</li>
					</ul>
				</div>
			</nav>

			<main class="content" style="min-height: 100%;">
				<div class="container-fluid p-0" id="contentPage">
					<?php echo $__env->make('contentDashboard', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
				</div>
			</main>

			<footer class="footer">
				<div class="container-fluid">
					<div class="row text-muted">
						<div class="col-6 text-left">
							<ul class="list-inline">
								<li class="list-inline-item">
									<a class="text-muted" href="#">Support</a>
								</li>
								<li class="list-inline-item">
									<a class="text-muted" href="#">Help Center</a>
								</li>
								<li class="list-inline-item">
									<a class="text-muted" href="#">Privacy</a>
								</li>
								<li class="list-inline-item">
									<a class="text-muted" href="#">Terms of Service</a>
								</li>
							</ul>
						</div>
						<div class="col-6 text-right">
							<p class="mb-0">
								&copy; 2018 - <a href="index.html" class="text-muted">AppStack</a>
							</p>
						</div>
					</div>
				</div>
			</footer>
		</div>
	</div>
	
	<script src="dist/js/app.js"></script>
	<script src="js/feather.js"></script>
	<script src="js/function.js"></script>
	<script src="html2pdf/html2pdf.bundle.min.js"></script>
</body>

</html>